using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class SCONSULT_REASONDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors
        public SCONSULT_REASONDB()
        {
        }
        #endregion

        #region Properties
        #endregion

        #region Methods
        public List<SCONSULT_REASON> GetItemsByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<SCONSULT_REASON> objReturn = null;
            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                     LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                     objReturn = dbContext.usp_SCONSULT_REASON_getitemsByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                     LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }
            return objReturn;
        }
        #endregion
    }
}
